using System;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Class UnhandledExceptionDialog
	/// </summary>
	public class UnhandledExceptionDialog : System.Windows.Forms.Form // do NOT use VbecsBaseForm here since this can create exception loop. 
	{
		/// <summary>
		/// An error message to be displayed to user when an exception happens in exception handling itself. 
		/// Do not move this error message to resources there since this can be any error - like HDD crash or CLR shutdown.
		/// </summary>
		private static readonly string FatalSystemErrorMessage = "Fatal system error - unable to handle an exception. An error occurred in error handling code when trying to process another exception.";

		private System.Windows.Forms.TextBox txtExceptionDetails;
		private System.Windows.Forms.Button btnShutdown;

		private System.Windows.Forms.Button btnShowDetails;
		private System.Windows.Forms.Label lblExceptionMessage;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.PictureBox pictureBox1;

		private Exception _subjectException = null;

		/// <summary>
		/// VbecsLogo object
		/// </summary>
		protected gov.va.med.vbecs.GUI.VbecsLogo vbecsLogo1;

		private System.Windows.Forms.Button btnCopy;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="xcp"></param>
		public UnhandledExceptionDialog( Exception xcp ) : base()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			_subjectException = xcp;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(UnhandledExceptionDialog));
			this.txtExceptionDetails = new System.Windows.Forms.TextBox();
			this.lblExceptionMessage = new System.Windows.Forms.Label();
			this.btnShutdown = new System.Windows.Forms.Button();
			this.btnCopy = new System.Windows.Forms.Button();
			this.btnShowDetails = new System.Windows.Forms.Button();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.vbecsLogo1 = new gov.va.med.vbecs.GUI.VbecsLogo();
			this.SuspendLayout();
			// 
			// txtExceptionDetails
			// 
			this.txtExceptionDetails.Anchor = System.Windows.Forms.AnchorStyles.Top;
			this.txtExceptionDetails.BackColor = System.Drawing.SystemColors.Info;
			this.txtExceptionDetails.ForeColor = System.Drawing.SystemColors.InfoText;
			this.txtExceptionDetails.Location = new System.Drawing.Point(8, 144);
			this.txtExceptionDetails.Multiline = true;
			this.txtExceptionDetails.Name = "txtExceptionDetails";
			this.txtExceptionDetails.ReadOnly = true;
			this.txtExceptionDetails.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.txtExceptionDetails.Size = new System.Drawing.Size(485, 223);
			this.txtExceptionDetails.TabIndex = 3;
			this.txtExceptionDetails.Text = "No exception details available";
			this.txtExceptionDetails.Visible = false;
			this.txtExceptionDetails.WordWrap = false;
			// 
			// lblExceptionMessage
			// 
			this.lblExceptionMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblExceptionMessage.Location = new System.Drawing.Point(60, 40);
			this.lblExceptionMessage.Name = "lblExceptionMessage";
			this.lblExceptionMessage.Size = new System.Drawing.Size(430, 64);
			this.lblExceptionMessage.TabIndex = 8;
			this.lblExceptionMessage.Text = "Application error occurred. Please restart the application. The error information " +
				"will be reported to the administrator and may be found in the application log.";
			// 
			// btnShutdown
			// 
			this.btnShutdown.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnShutdown.Location = new System.Drawing.Point(413, 112);
			this.btnShutdown.Name = "btnShutdown";
			this.btnShutdown.Size = new System.Drawing.Size(80, 23);
			this.btnShutdown.TabIndex = 10;
			this.btnShutdown.Text = "&Shutdown";
			this.btnShutdown.Click += new System.EventHandler(this.btnShutdown_Click);
			// 
			// btnCopy
			// 
			this.btnCopy.Location = new System.Drawing.Point(104, 112);
			this.btnCopy.Name = "btnCopy";
			this.btnCopy.Size = new System.Drawing.Size(120, 23);
			this.btnCopy.TabIndex = 11;
			this.btnCopy.Text = "&Copy to Clipboard";
			this.btnCopy.Click += new System.EventHandler(this.btnCopy_Click);
			// 
			// btnShowDetails
			// 
			this.btnShowDetails.Location = new System.Drawing.Point(8, 112);
			this.btnShowDetails.Name = "btnShowDetails";
			this.btnShowDetails.Size = new System.Drawing.Size(80, 23);
			this.btnShowDetails.TabIndex = 12;
			this.btnShowDetails.Text = "Show &Details";
			this.btnShowDetails.Click += new System.EventHandler(this.btnShowDetails_Click);
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(8, 40);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(40, 40);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox1.TabIndex = 13;
			this.pictureBox1.TabStop = false;
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Dock = System.Windows.Forms.DockStyle.Top;
			this.vbecsLogo1.Font = new System.Drawing.Font("Arial", 10F, System.Drawing.FontStyle.Bold);
			this.vbecsLogo1.ForeColor = System.Drawing.Color.AntiqueWhite;
			this.vbecsLogo1.Location = new System.Drawing.Point(0, 0);
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(502, 30);
			this.vbecsLogo1.TabIndex = 14;
			this.vbecsLogo1.Title = null;
			// 
			// UnhandledExceptionDialog
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(502, 143);
			this.ControlBox = false;
			this.Controls.Add(this.vbecsLogo1);
			this.Controls.Add(this.pictureBox1);
			this.Controls.Add(this.btnShowDetails);
			this.Controls.Add(this.btnCopy);
			this.Controls.Add(this.btnShutdown);
			this.Controls.Add(this.lblExceptionMessage);
			this.Controls.Add(this.txtExceptionDetails);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "UnhandledExceptionDialog";
			this.ShowInTaskbar = false;
			this.Text = "VBECS - System Error";
			this.TopMost = true;
			this.Load += new System.EventHandler(this.UnhandledExceptionDialog_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void btnCopy_Click(object sender, System.EventArgs e)
		{
			Clipboard.SetDataObject( this.txtExceptionDetails.Text, true );
			GuiMessenger.ShowMessageBox( Common.StrRes.InfoMsg.Common.ExceptionDetailsWereCopiedToClipboard() );
		}

		private void btnShutdown_Click(object sender, System.EventArgs e)
		{	
			try
			{
				BOL.LockManager.UnlockAllRecordsForUser(Common.LogonUser.LogonUserName, false);
			}
			catch{}		//Any errors? - Oh well, they'll get caught on VBECS start up
			this.Close();
			
		}

		private void btnShowDetails_Click(object sender, System.EventArgs e)
		{
			// If the text box is visible, hide it, resize the form, and
			// change the text of the hide/display button.
			if( this.txtExceptionDetails.Visible )
			{
				this.Height = 167;
				this.Width = 508;
				this.txtExceptionDetails.Visible = false;
				this.btnShowDetails.Text = "Show Details";
			}
			// if the text box is not visible, display it, resized the
			// form, and change the text of the hide/display button.
			else
			{
				this.Height = 400;
				this.txtExceptionDetails.Visible = true;
				this.btnShowDetails.Text = "Hide Details";
			}
		}

		private void UnhandledExceptionDialog_Load(object sender, System.EventArgs e)
		{
			txtExceptionDetails.Text = ExceptionManagement.ExceptionManager.FormatExceptionInfoAndDumpToString( _subjectException );			
			this.PerformLayout();			
		}

		/// <summary>
		/// DisplayExceptionInExceptionHandlingMessage
		/// </summary>
		public static void DisplayExceptionInExceptionHandlingMessage()
		{
			// Do not get an error message from resources there since this can be any error - like HDD crash or CLR shutdown.
			// Hence - please do not replace with GuiMessenger. 
			MessageBox.Show( FatalSystemErrorMessage, "VBECS Fatal Error", MessageBoxButtons.OK, MessageBoxIcon.Error );
		}
	}
}
